<?php

// Disallow direct access to this file for security reasons
if(!defined("IN_MYBB"))
{
	die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

$plugins->add_hook("pre_output_page", "quickthemeoc_run");
$plugins->add_hook("index_start", "quickthemeoc_update");
$plugins->add_hook("global_start", "quickthemeoc_global");

function quickthemeoc_info()
{
	return array(
		"name" => "هاك تغيير الاستايل للاعضاء",
		"description" => "السماح للاعضاء بالقدرة علي تغيير الاستايل.",
		"website" => "http://mods.mybb.com/view/quick-theme-onchange",
		"author" => "EviLito",
		"authorsite" => "http://community.mybb.com/user-10968.html",
		"version" => "2.1",
		"compatibility" => "16*",
		"guid" => "01d65dc78eac227f93dd09b143fccd35",
	);
}

function quickthemeoc_activate()
{
	global $db;

	require MYBB_ROOT.'/inc/adminfunctions_templates.php';
	find_replace_templatesets("footer", '#'.preg_quote('<!-- End powered by -->').'#', '<!-- End powered by --><quickthemeoc>');
}

function quickthemeoc_deactivate()
{
	global $db;

	require  MYBB_ROOT.'/inc/adminfunctions_templates.php';
	find_replace_templatesets("footer", '#'.preg_quote('<quickthemeoc>').'#', '', 0);
}

function quickthemeoc_run($page)
{
	global $mybb, $db, $lang;
	
	$lang->load("usercp");
	
	$list_label = $lang->style;
	
	$theme_select = build_theme_select("style", $mybb->user['style']);
		
	if(strpos($theme_select, '</select>') === false)
	{
		$theme_select .= '</select>';
	}

	$theme_select = str_replace("<select", "<select onchange=\"this.form.submit()\" class=\"smalltext\"", $theme_select);
		
	$data = "\n<form method=\"post\" action=\"./index.php?action=quickthemeoc\">\n";
	$data .= "<span class=\"smalltext\"><strong>".$list_label." </strong></span><input type=\"hidden\" name=\"uid\" value=\"{$mybb->user['uid']}\" />";
	$data .= $theme_select."\n</form>";
	
	preg_match('#'.preg_quote('<quickthemeoc>').'#i', $page, $matches);
	if($matches[0])
	{
		$page = str_replace($matches[0], $data, $page);
	}
	
	return $page;
}

function quickthemeoc_update()
{
	global $mybb, $db, $lang;
	
	if($mybb->input['action'] == 'quickthemeoc')
	{
		if(isset($mybb->input['style']) && ($mybb->request_method == 'post' || $mybb->request_method == 'get'))
		{
			$lang->load('usercp');
			$lang->load('admin/style_themes');
			
			$selected_theme = $db->simple_select('themes', 'tid', 'tid = '.intval($mybb->input['style']));
			if ($db->num_rows($selected_theme) > 0 || intval($mybb->input['style']) == 0)
			{
				if($mybb->user['uid'])
				{ 
					$db->update_query('users', array('style' => intval($mybb->input['style'])), "uid='{$mybb->user['uid']}'");
				}
				else
				{
					if(intval($mybb->input['style']) == 0)
						my_unsetcookie('quickthemeoc');
					else
						my_setcookie('quickthemeoc', intval($mybb->input['style']));
				}			
				redirect($_SERVER['HTTP_REFERER'], $lang->redirect_optionsupdated);
			}
			else
			{
				error($lang->error_invalid_theme);
			}			
		}
	}
}

function quickthemeoc_global()
{
	global $mybb;
	
	if($mybb->user['uid'] == 0 && intval($mybb->cookies['quickthemeoc']) > 0)
	{
		$mybb->user['style'] = intval($mybb->cookies['quickthemeoc']);
	}
}

?>
